Imports System.Collections.Generic
Imports System.Linq
Imports System.Text
Imports System.Windows
Imports System.Windows.Controls
Imports System.Windows.Data
Imports System.Windows.Documents
Imports System.Windows.Input
Imports System.Windows.Media
Imports System.Windows.Media.Imaging
Imports System.Windows.Navigation
Imports System.Windows.Shapes
Imports System.Reflection
Imports System.Windows.Markup
Imports System.ComponentModel

Namespace Assets002ns

    Public Class ToolBarUserControl
        Inherits UserControl
        Private _parentWindow As WindowBase = Nothing
        Public Event _parentWindow_PropertyChanged As PropertyChangedEventHandler
        Public Event _Loaded As RoutedEventHandler

        Public Sub New()
            InitializeComponent()
            RaiseEvent _Loaded(New RoutedEventHandler(AddressOf MainView_Loaded), New RoutedEventArgs)
        End Sub
        
        Private Sub MainView_Loaded(ByVal sender As Object, ByVal e As RoutedEventArgs)
            If Not System.ComponentModel.DesignerProperties.GetIsInDesignMode(Me) Then
                _parentWindow = DirectCast(Window.GetWindow(Me), WindowBase)
                ' _parentWindow.PropertyChanged += New System.ComponentModel.PropertyChangedEventHandler(AddressOf _parentWindow_PropertyChanged)
                RaiseEvent _parentWindow_PropertyChanged(sender, New PropertyChangedEventArgs(e.Source))
                RebindControls()
            End If
        End Sub
        
        Private Sub RebindControls()
            txtRecord.Text = (_parentWindow.CurrentRecordPosition + 1).ToString()
            lbTotalRecords.Content = "( " & _parentWindow.TotalRecords.ToString() & " )"
            sldRecords.Value = _parentWindow.CurrentRecordPosition + 1
            sldRecords.Maximum = CDbl(_parentWindow.TotalRecords)
        End Sub
        
        Private Sub cmbWindowSelect_SelectionChanged(ByVal sender As Object, ByVal e As SelectionChangedEventArgs)
            Dim lbi As ComboBoxItem = TryCast(TryCast(sender, ComboBox).SelectedItem, ComboBoxItem)
            Dim namespaceType As String = Me.[GetType]().[Namespace]
            Dim typeName As String = (namespaceType & ".") + lbi.Name
            Dim windowType As Type = Assembly.GetExecutingAssembly().[GetType](typeName)
            If windowType IsNot Nothing Then
                Dim detailWindow As Window = DirectCast(Activator.CreateInstance(windowType), Window)
                detailWindow.Show()
                detailWindow.Activate()
            Else
                Throw New ApplicationException("Couldn't find the " & typeName & " in the current Assembly")
            End If
        End Sub
        
        Private Sub _parentWindow_PropertyChanged1(ByVal sender As Object, ByVal e As PropertyChangedEventArgs)
            RebindControls()
        End Sub
        Private Sub btn_Click(ByVal sender As Object, ByVal e As RoutedEventArgs)
            _parentWindow.HandleToolbarButton_Click(sender, e)
            RebindControls()
        End Sub

        Private Sub sldRecords_ValueChanged(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim slider As Slider = DirectCast(sender, Slider)

            If _parentWindow Is Nothing Then
                Return
            End If

            'Only update if the Slider was manually 
            If _parentWindow.CurrentRecordPosition <> (slider.Value - 1) Then
                _parentWindow.CurrentRecordPosition = (slider.Value - 1)
                RebindControls()
            End If
        End Sub

    End Class
End Namespace
