/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
/**
 * jqScheduler
 * Tony Tomov tony@trirand.com
 * http://trirand.net 
**/

(function($){
$.jqschedule = 
{	 
	/**
	 * is the id of the calendar in the template file. If needed can be changed dynamically
	 */
	calendarid : "#calendar",
	eventid : "#event",
	/**
	 * the url to all ajax cals. Should be set dynamucally from the application
	*/
	calendarurl : "",
	/**
	 * locales which should be set dynamically 
	 * Note that this locales are used only from the common JS. the other should
	 * be defined in the application specifically file.
	 */
	locales : {
		dateFormat : 'dd/MM/yyyy',
		bSave: 'Save',
		bAdd: 'Add',
		bDelete: 'Delete',
		bCancel: 'Cancel',
		bChange: 'Change',
		bClose : 'Close',
		bSearch : 'Find',
		editCaption : 'Edit event',
		addCaption: 'Add new event',
		userCaption: 'Change Calendar',
		searchCaption: 'Advanced search'
	},
	_viewmode_ : false,
	/**
	 *The columns for advanced search.
	 * Should be changed at runtime, because of language
	 */
	searchCols : [],
	searchOpers : [],
	/**
	 * Used in serach display. When the date is clicked switch to 
	 * agendaDay  of the clicked day
	 *  
	 * @param unixdate integer - the date in unixtimestamp format
	 * @param cal_id string the id of the calendar
	 */
	gotoDayEventView : function( unixdate, cal_id ) 
	{
		$("#b_search_cal").trigger('click');
		var date = $.fullCalendar.parseDate( parseInt(unixdate,10) );
		$($.jqschedule.calendarid).fullCalendar( 'gotoDate', date.getFullYear() , date.getMonth(), date.getDate() );
		$($.jqschedule.calendarid).fullCalendar( 'changeView', 'agendaDay' );
	},
	/**
	 * Opens a modal dialog for editing a data when on existing event is clicked.
	 * Used in eventClick in fullcalendar
	 * 
	 * @param event  object is an Event Object that holds the event's information (date, title, etc).
	 * @param jsEvent object holds the native JavaScript event with low-level information such as click coordinates.
	 * @param view view holds the current View Object.
	 * 
	 */
	eventEditDialog : function(event, jsEvent, view  )
	{
		var dialogContent = $($.jqschedule.eventid);
		// reset Form
		$("input,textarea,select",dialogContent).val('');
		// hide the time picker in case of allday
		if(event.allDay) {
			$('#endtime, #starttime', dialogContent).hide();
		} else {
			$('#endtime, #starttime', dialogContent).show();
		}
		$('#all_day',dialogContent).attr('checked',event.allDay);
		$('#title',dialogContent).val(event.title);
		// FireFox 4 fix
		setTimeout(function(){$('#description',dialogContent).val(event.description);},100);
		//alert($('#description','#event').val());	
		$('#location',dialogContent).val(event.location);
		$('#categories',dialogContent).val(event.className);
		$('#access',dialogContent).val(event.access);
		$('#start',dialogContent).val( $.fullCalendar.formatDate( event.start, $.jqschedule.locales.dateFormat ) );
		$('#starttime', dialogContent).val( $.fullCalendar.formatDate( event.start, 'HH:mm' ) );
		$('#end',dialogContent).val( $.fullCalendar.formatDate( event.end ? event.end : event.start, $.jqschedule.locales.dateFormat ) );
		$('#endtime').val( $.fullCalendar.formatDate( event.end ? event.end : event.start, 'HH:mm' ) );

		var buttons = {};
		var dateformat = $("#start",dialogContent).datepicker('option','dateFormat');
		var dp;
		if( $.jqschedule._viewmode_ ) {
			buttons[$.jqschedule.locales.bClose] = function ()
			{
				dialogContent.dialog("close");
			}
		} else {
		buttons[$.jqschedule.locales.bSave] = function() {
		
			var st = $.datepicker.parseDate(dateformat, $('#start',dialogContent).val());
			var sttime = $('#starttime',dialogContent).val();
			sttime = sttime ? sttime.split(":") : ['0','0'];
			st.setHours(parseInt(sttime[0],10),parseInt(sttime[1],10));

			var en = $.datepicker.parseDate(dateformat, $('#end',dialogContent).val());
			if(!en) en = $.datepicker.parseDate(dateformat, $('#start',dialogContent).val());
			var entime = $('#endtime',dialogContent).val();
			entime = entime ? entime.split(":") : ['0','0'];
			en.setHours(parseInt(entime[0],10),parseInt(entime[1],10));
		
			if(en.getTime()-st.getTime() < 0 )
			{
				alert("End time is little than start time");
				return;
			}
			event.start = st;
			event._start = st;
			event.end=en;
			event._end = en;
			if($("#all_day", dialogContent).attr("checked")) {
				event.allDay = true;
			} else {
				event.allDay = false;
			}
			event.title = $('#title',dialogContent).val();
			if( $.trim(event.title) == '') { 
				alert("Title is required");
				return;
			}
			event.description = $('#description',dialogContent).val();
			event.location = $('#location',dialogContent).val();
			event.className = $('#categories',dialogContent).val();
			event.access = $('#access',dialogContent).val();
			// build post data
			dp ={};
			dp.event_id = event.id;
			dp.start = event.start.getTime()/1000;
			dp.end = event.end.getTime()/1000;
			dp.title = event.title;
			dp.description = event.description;
			dp.location = event.location;
			dp.categories = $('#categories',dialogContent).val();
			dp.access = event.access;
			dp.all_day = event.allDay ? 1 : 0;
			// oper set the type of the operation
			dp.oper = 'editEvent';
			// send it to server
			$.ajax({
				url: $.jqschedule.calendarurl, 
				data:dp, 
				dataType:'json', 
				type:'post',
				success : function(res) {
					// update 
					$($.jqschedule.calendarid).fullCalendar('updateEvent', event);
					dialogContent.dialog("close");
				}
			});
			// update 
			//$($.jqschedule.calendarid).fullCalendar('updateEvent', event);
			//dialogContent.dialog("close");
		};
		
		buttons[$.jqschedule.locales.bDelete] = function() {
			dp ={};
			dp.event_id = event.id;
			dp.oper = 'removeEvent';
			$.ajax({url: $.jqschedule.calendarurl, data:dp, dataType:'json', type:'post'});

			$($.jqschedule.calendarid).fullCalendar('removeEvents', event.id);

			dialogContent.dialog("close");
		};
		buttons[$.jqschedule.locales.bCancel] = function() {
			dialogContent.dialog("close");
		};
		}
		dialogContent.dialog({
			modal: true,
			width: 490,
			closeOnEscape : false,
			position : { at: 'center bottom', of: $.jqschedule.calendarid },
			title: $.jqschedule.locales.editCaption,
			close: function() {
				dialogContent.dialog("destroy");
				dialogContent.hide();
				dialogContent = null;
				$.jqschedule._viewmode_ = false;
			},
			buttons: buttons
		}).show()
		$(".ui-dialog").css('font-size','12px');
		
		return false;
	},
	/**
	 * Opens a modal dialog for adding new data event
	 * Used in dayClick in fullcalendar
	 * Refer here 
	 * http://arshaw.com/fullcalendar/docs/mouse/dayClick/
	 * for full parameter description
	 * 
	 */
	eventAddDialog : function(date, allDay, jsEvent, view)
	{
		var dialogContent = $($.jqschedule.eventid);
		// reset Form
		$("input,textarea,select",dialogContent).val('');
		if(allDay) {
			$('#endtime, #starttime', dialogContent).hide();
		} else {
			$('#endtime, #starttime', dialogContent).show();
		}
		
		$('#all_day',dialogContent).attr('checked',allDay);
		// FireFox 4 fix
		setTimeout(function(){$('#description',dialogContent).val('');},100);
	
		$('#start',dialogContent).val( $.fullCalendar.formatDate( date, $.jqschedule.locales.dateFormat ) );
		$('#starttime', dialogContent).val( $.fullCalendar.formatDate( date, 'HH:mm' ) );
		$('#end',dialogContent).val( $.fullCalendar.formatDate( date , $.jqschedule.locales.dateFormat ) );
		$('#endtime',dialogContent).val( $.fullCalendar.formatDate( date , 'HH:mm' ) );
		
		
		var buttons = {};
		var dateformat = $("#start",dialogContent).datepicker('option','dateFormat');
		var dp, event;
		buttons[$.jqschedule.locales.bAdd] = function() {
			event = {};
			var st = $.datepicker.parseDate(dateformat, $('#start',dialogContent).val());
			var sttime = $('#starttime', dialogContent).val();
			sttime = sttime ? sttime.split(":") : ['0','0'];
			st.setHours(parseInt(sttime[0],10),parseInt(sttime[1],10));

			var en = $.datepicker.parseDate(dateformat, $('#end',dialogContent).val());
			if(!en) en = $.datepicker.parseDate(dateformat, $('#start',dialogContent).val());
			var entime = $('#endtime').val();
			entime = entime ? entime.split(":") : ['0','0'];
			en.setHours(parseInt(entime[0],10),parseInt(entime[1],10));
		
			if(en.getTime()-st.getTime() < 0 )
			{
				alert("End time is little than start time");
				return;
			}
			event.start = st;
			event._start = st;
			event.end=en;
			event._end = en;
			if($("#all_day", dialogContent).attr("checked")) {
				event.allDay = true;
			} else {
				event.allDay = false;
			}
			event.title = $('#title',dialogContent).val();
			if( $.trim(event.title) == '') { 
				alert("Title is required");
				return;
			}
			event.description = $('#description',dialogContent).val();
			event.location = $('#location',dialogContent).val();
			event.className = $('#categories',dialogContent).val();
			event.access = $('#access',dialogContent).val();
			
			// build post data
			dp ={};
			//dp.event_id = event.id;
			dp.start = event.start.getTime()/1000;
			dp.end = event.end.getTime()/1000;
			dp.title = event.title;
			dp.description = event.description;
			dp.location = event.location;
			dp.categories = $('#categories',dialogContent).val();
			dp.access = event.access;
			dp.all_day = event.allDay ? 1 : 0;
			
			dp.oper = 'newEvent';
			
			// send it to server
			$.ajax({
				url: $.jqschedule.calendarurl,
				data: dp,
				dataType:'json', 
				type:'POST',
				success : function(res, err)
				{
					if(res.event_id) {
						event.id = res.event_id;
						event._id = res.event_id;
						$($.jqschedule.calendarid).fullCalendar('renderEvent', event, false);
						dialogContent.dialog("close");
					}
				}
			});
		};
		buttons[$.jqschedule.locales.bCancel] = function() {
			dialogContent.dialog("close");
		};

		dialogContent.dialog({
			modal: true,
			width: 490,
			position : { at: 'center bottom', of: $.jqschedule.calendarid },
			closeOnEscape : false,
			title: $.jqschedule.locales.addCaption,
			close: function() {
				dialogContent.dialog("destroy");
				dialogContent.hide();
				dialogContent = null;
			},
			buttons: buttons
		}).show()
		$(".ui-dialog").css('font-size','12px');
	},
	eventLoading : function ()
	{
		// to be written
	},
	/**
	 * Function to be called when the user drop a event. A jQuery UI drag and drop should be available
	 * The function is used in eventDrop event in fullcalendar
	 * refer here: http://arshaw.com/fullcalendar/docs/event_ui/eventDrop/
	 * for full parameter description
	 */
	eventDrop : function(event,dayDelta,minuteDelta,allDay,revertFunc) {
		//$(".ui-tooltip").tooltip('close');
		if(event.end == null) {event.end = event.start;}
		$.ajax({
			url: $.jqschedule.calendarurl, 
			data:{oper:'moveEvent',event_id:event.id,start:event.start.getTime()/1000, end:event.end.getTime()/1000, all_day: allDay ? 1 :0},
			dataType:'json', 
			type:'post'
		});
	},
	/** 
	 * Function to be called when the event is resized. Use it in eventDrop in fullcalendar
	 * Refer here: http://arshaw.com/fullcalendar/docs/event_ui/eventResize/
	 * for parameter description
	 */
	eventResize : function( event, dayDelta, minuteDelta, revertFunc, jsEvent, ui, view ) { 
		//$(".ui-tooltip").tooltip('close');
		$.ajax({
			url:$.jqschedule.calendarurl,//'eventcal.php?oper=resizeEvent',
			data:{oper:'resizeEvent',event_id:event.id,start:event.start.getTime()/1000, end:event.end.getTime()/1000},
			dataType:'json', 
			type:'post'
		});
	},
	/**
	 * Function to be called when any event is render. Used in renderEven in fullcalendar
	 * The jQuery UI tooltip widget should be available.
	 * Refer here: http://arshaw.com/fullcalendar/docs/event_rendering/eventRender/
	 */
	eventRender: function(event, element, view) 
	{
		try {
			if (event.description) {
				element.tooltip({
					position: {my: "left bottom",	at: "center top",	offset: "-30 -10", of: element},
					content: function(r) {return event.description;}
				});
			}
		} catch (e) {}
	},
	/**
	 * this function lunch a dialog for changing the calendar user. Used when the
	 * appropriate button is clicked. uses ui dialog
	 */
	changeCalendarUser : function()
	{
		var udlg = $("#caluser");
		udlg.dialog({
			modal: true,
			width: 400,
			title: $.jqschedule.locales.userCaption, //'$locale->title_user',
			close: function() {
				udlg.dialog("destroy");
				udlg.hide();
				udlg = null;
			},
			buttons: [{
				text : $.jqschedule.locales.bChange, //'$locale->change',
				click : function() {
					var uid = $("#switchuser", this).val();
					$.ajax({
						url:$.jqschedule.calendarurl, //'eventcal.php?oper=switchUser',
						data:{_user_id: uid, oper:'switchUser'},
						dataType:'json',
						type:'post',
						success : function(r,e) { //'#$this->calenderid'
							$($.jqschedule.calendarid).fullCalendar( 'refetchEvents' );
							$("#common_search").val("");
							$(".fnd-results").html("");
							$("#search_table").empty();
							$("#cal_user").html( $("#switchuser option:selected").text() );
						}
					});
					udlg.dialog("close");
				}
			}, {
				text : $.jqschedule.locales.bCancel,//'$locale->cancel',
				click : function(){
					udlg.dialog("close");
				}
			}
			]
		}).show()
		$(".ui-dialog, .ui-dialog-buttonpane").css('font-size','12px');
		return false;
	},
	/**
	 * function to print a events from the current view
	 * TODO : to analyze when we are in search mode to print the events
	 */
	printEvents : function()
	{
		if($("#b_search_cal").hasClass('ui-state-active') ) {
			var sv = $("#common_search").val();
			var stype = 'simple';
			if(sv == "") {
				stype = "complex";
				var scal = $("#search_cal");
				if( scal) {
					var filters = scal.jqFilter('filterData');
					if(!filters.rules.length) { return false ;}
					try {
						// xmlJsonClass or JSON.stringify
						sv = xmlJsonClass.toJson(filters, '', '', false);
					} catch (e) {
						try {
							sv = JSON.stringify(filters);
						} catch (e2) { }
					}
				}
				
			}
			window.location=$.jqschedule.calendarurl+'?oper=printEvents&stype='+stype+'&search=true&svalue='+sv;
		} else {
			var curview = jQuery($.jqschedule.calendarid).fullCalendar('getView');
			var start = curview.start.getTime()/1000;
			var end = curview.end.getTime()/1000;
			window.location=$.jqschedule.calendarurl+'?oper=printEvents&start='+start+'&end='+end;
		}
		return false;
	},
	/**
	 * function to export a events from the current view in iCal format
	 * TODO : to analyze when we are in search mode to export the events
	 */
	exportEvents : function()
	{
		if($("#b_search_cal").hasClass('ui-state-active') ) {
			var sv = $("#common_search").val();
			var stype = 'simple';
			if(sv == "") {
				stype = "complex";
				var scal = $("#search_cal");
				if( scal) {
					var filters = scal.jqFilter('filterData');
					if(!filters.rules.length) { return false ;}
					try {
						// xmlJsonClass or JSON.stringify
						sv = xmlJsonClass.toJson(filters, '', '', false);
					} catch (e) {
						try {
							sv = JSON.stringify(filters);
						} catch (e2) { }
					}
				}
				
			}
			window.location=$.jqschedule.calendarurl+'?oper=exportEvents&stype='+stype+'&search=true&svalue='+sv;
		} else {
			var curview = jQuery($.jqschedule.calendarid).fullCalendar('getView');
			var start = curview.start.getTime()/1000;
			var end = curview.end.getTime()/1000;
			window.location=$.jqschedule.calendarurl+'?oper=exportEvents&start='+start+'&end='+end;
		}
		return false;
	},
	/**
	 * Toggle show function when the search button is clicked. See hideSearch.
	 * Used in jQuery toggle 
	 */
	showSearch : function()
	{
		var cs = $("#common_search").val();
		if(cs) {
			$("#common_search").val("");
			$("#b_common_search").trigger("click");
		}
		$(this).addClass('ui-state-active');
		$('.fc-view-agendaWeek, .fc-view-agendaDay, .fc-view-basicDay, .fc-view-basickWeek, .fc-view-month').hide();
		$('.fc-view-search').show();
		$("#common_search").focus();
	}, 
	hideSearch : function()
	{
		$(this).removeClass('ui-state-active');
		var activeView = $($.jqschedule.calendarid).fullCalendar('getView').name;
		$('.fc-view-search').hide();
		$('.fc-view-'+activeView).show();
	},
	_filSearchTable : function( result )
	{
		$("#search_table").empty();
		if(result && result.length) {
			$(".fnd-results").html(result.length);
			var tdata = "";
			var sep = "~`";
			$.each(result, function() {
				var sd = $.fullCalendar.parseDate(this.start);
				var ed = $.fullCalendar.parseDate(this.end);
				var sh = $.fullCalendar.formatDate(sd, 'HH:mm');
				var eh = $.fullCalendar.formatDate(ed, 'HH:mm');
				var ad = this.allDay ? 'all day': sh + " - "+eh;
				sd = $.fullCalendar.formatDate(sd, 'ddd  dd MMM yyyy');
				ed = $.fullCalendar.formatDate(ed, 'ddd  dd MMM yyyy');
				if(sd != ed) ad += " "+ed; 
				tdata += "<tr id='"+this.id+"'><th class='ui-event-cell ui-widget-content'><a href=\"javascript:jQuery.jqschedule.gotoDayEventView(\'"+this.start+"\');\">"+sd+"</a></th><td class='ui-event-time ui-widget-content'>"+ad+"</td><td class='ui-event-title ui-widget-content'><a href=\"javascript:jQuery.jqschedule.editFromSearch(\'"+this.id+"\');\" class='' style='border: 0px none;text-decoration:  underline;'>"+this.title+"</a></td>";
				tdata += "<td class='source' style='display:none;'>";
				tdata += this.id+sep+ this.title+sep+this.start+sep+this.end+sep+this.description+sep+this.location+sep+this.className+sep+this.access+sep+this.allDay+sep+this.user_id;
				tdata += "</td>";
				tdata += "</tr>";
			});
			$("#search_table").append(tdata);
		}
		
	},
	/**
	 * Function to perform a single search when the appropriate button is clicked
	 * 
	 */
	doSimpleSearch : function()
	{
		var sv = $("#common_search").val();
		var tdata = "";
		if(sv) {
			$.ajax({
				url: $.jqschedule.calendarurl, //'eventcal.php?oper=getEvent',
				data:{search:true,stype:'simple', svalue: sv, oper:'getEvent'},
				dataType:'json', 
				type:'POST',
				success : function(res, err)
				{
					$.jqschedule._filSearchTable(res);
				}
			});
		} else {
			$(".fnd-results").html("");
			$("#search_table").empty();
		}
	},
	buildLocalSearch : function ()
	{
		var sa, so;
		$('label', $.jqschedule.eventid).each(function(i){ 
			sa ={};
			sa.name = $(this).attr('for');
			sa.label = $(this).html();
			if(sa.name == 'categories' || sa.name == 'access') {
				sa.inputtype ='select';
				so = {};
				$("#"+sa.name+' option', $.jqschedule.eventid).each(function(){
					so[$(this).val()] = $(this).text();
				});
				sa.searchoptions = { value: so};
			} else if(sa.name == 'all_day'){
				sa.inputtype ='select';
				so = {'1': 'Yes','0':'No'};
				sa.searchoptions = { value: so};
			} else if( sa.name=="start" || sa.name=="end") {
				sa.searchtype = 'date';
				sa.searchoptions = {
					size : 20,
					sopt : ['eq','gt', 'ge', 'lt','le'],
					dataInit : function(el) { $(el).datetimepicker(); }
				}
			} else {
				sa.searchoptions = { size: 20};
			}
			$.jqschedule.searchCols[i]= sa;
		});
	},
	/**
	 * Function which create the advanced search dialog
	 */
	advancedSearchDlg : function ()
	{
		$("#search_cal").jqFilter({
			columns : $.jqschedule.searchCols,
			filter : {"groupOp": "AND",rules:[{"field":$.jqschedule.searchCols[0].name,"op":'eq',"data":""}]},
			_gridsopt: $.jqschedule.searchOpers
		});
		$("#search_cal").dialog({
			modal: true,
			width: 'auto',
			autoOpen : false,
			title: $.jqschedule.locales.searchCaption,
			close: function() {
				//this.hide();
				//this.dialog("destroy");
			},
			buttons: [{
				text : $.jqschedule.locales.bSearch,
				click : function() {
					var scal = $("#search_cal"),
					res,
					filters = scal.jqFilter('filterData');
					if(!filters.rules.length) { return ;}
					try {
						// xmlJsonClass or JSON.stringify
						res = xmlJsonClass.toJson(filters, '', '', false);
					} catch (e) {
						try {
							res = JSON.stringify(filters);
						} catch (e2) { }
					}
					if(res) {
						$.ajax({
							url: $.jqschedule.calendarurl, //'eventcal.php?oper=getEvent',
							data:{search:true,stype:'complex', svalue: res, oper:'getEvent'},
							dataType:'json', 
							type:'POST',
							success : function(res, err)
							{
								$.jqschedule._filSearchTable(res);
							}
						});
					}
					scal.dialog("close");
				}
			}, {
				text : $.jqschedule.locales.bClose,
				click : function(){
					$("#search_cal").dialog("close");
				}
			}
			]
		});
		$(".ui-dialog, .ui-dialog-buttonpane").css('font-size','12px');
	},
	editFromSearch : function ( eventid )
	{
		var sep = "~`";
		var data = $("tr#"+eventid+" td.source").html().split(sep);
		var maps = ['id','title','start', 'end','description','location','className','access','allDay','user_id'];
		var event = {};
		$.each(maps, function(i){
			if(this=='start' || this == 'end') { data[i] = new Date( parseFloat(data[i])*1000 ); }
			if(this=='allDay') { data[i] = data[i] == '1' ? true : false;}
			event[this] = data[i];
		});
		$.jqschedule._viewmode_ = true;
		$.jqschedule.eventEditDialog( event );
		//console.log(data);
	},
	eventsFunc : function (start, end, callback)
	{
        $.ajax({
            url: $.jqschedule.calendarurl,
            dataType: 'json',
			type: 'POST',
            data: {
				oper:'getEvent',
                // our hypothetical feed requires UNIX timestamps
                start: start.getTime()/1000,
                end: end.getTime()/1000
            },
            success: function(doc, err) {
                callback(doc);
            }
        });		
	},
	/**
	 * Main function where all things are happen
	 */
	processScript :function() 
	{
		// datepicker at left side
		// this is special additional settiong
		$('#datepicker').datepicker( {
			'dateFormat': 'yy-mm-dd',
			onSelect: function(dateText, inst) {
				var dateset = dateText.split('-');
				$($.jqschedule.calendarid).fullCalendar( 'gotoDate', parseInt(dateset[0],10) , parseInt(dateset[1],10)-1, parseInt(dateset[2],10) );
			}
		});
		
		// atach datepickers pop-up to edit form
		$('#start, #end', $.jqschedule.eventid).datepicker();
		// show hide timepicker if allday
		$('#all_day',$.jqschedule.eventid).click(function(){
			if(this.checked) {
				$('#endtime, #starttime', $.jqschedule.eventid).val('00:00').hide();
			} else {
				$('#endtime, #starttime', $.jqschedule.eventid).show();
			}
		});
		
		$('.custbutton').height($('table.fc-header').height());
		
		$('#b_user_change').click(jQuery.jqschedule.changeCalendarUser);
		$('#b_export_ical').click(jQuery.jqschedule.exportEvents);
		$('#b_print_cal').click(jQuery.jqschedule.printEvents);
		$('.fc-content',$.jqschedule.calendarid).append( $(".fc-view-search" ));
		$('#b_search_cal').toggle(jQuery.jqschedule.showSearch,jQuery.jqschedule.hideSearch);
		$('#b_common_search').click(jQuery.jqschedule.doSimpleSearch);
		$('#b_adv_search').click(function(){$("#search_cal").dialog('open');return false;});
		$('.jq-button').hover(	function(){	$(this).addClass('ui-state-hover');},function(){ $(this).removeClass('ui-state-hover');	});
		$.jqschedule.buildLocalSearch();
		$.jqschedule.advancedSearchDlg();
	}
}
})(jQuery);

