<?php 
class MembersController extends AppController { 
	var $name = 'Members'; 
	var $uses = 'Member'; 
	var $components = array('Security');
	var $helpers = array('Html', 'Form', 'Paginator', 'Js'); 

	function index() { 
		if (isset($_SESSION['Member']['foundset'])) {
		  $this->redirect(array('action'=>'querylist'));
        }
		$this->layout = "index";
		$this->Member->recursive = -1; 
		$this->set('members', $this->paginate()); 
		$page['current_model'] = 'Member';
		$page['current_controller'] = 'members';
		$this->set('page', $page);
	} 

	function view($id = null) { 
		if (!$id || $id == 0) {
			// if invalid id (0) or missing id, use current_record as id
			if (!isset($_SESSION['Member']['current_record']))
				{
				// if invalid id and missing SESSION variable, get first record as current id
				$conditions = array();
				$first_record = $this->Member->find('first', array('conditions'=>$conditions,'recursive'=>-1, 'fields'=>array('Member.id'),'order'=>array('Member.id ASC')));
				$id = $first_record['Member']['id'];
				$_SESSION['Member']['current_record']=$id;
				}	
				else {
				$id = $_SESSION['Member']['current_record'];				
				}	
		}
		$this->layout = "view";
		// put the current record id into session variable
		$_SESSION['Member']['current_record'] = $id;
		// record navigation variables 
		$this->data=$this->Member->read(null, $id); 
		if (isset($_SESSION['Member']['foundset'])) {
			$conditions = array('Member.id'=>$_SESSION['Member']['foundset']);
			$foundset_record_count = $_SESSION['Member']['foundset'];
			// get record position within foundset
			$record_position = '';
			//RecordPositionComment $record_position = array_search($id,$_SESSION['Member']['foundset']) + 1;
		} else {
			// get list of keys for display of record position
			$record_position = '';
			//RecordPositionComment $conditions = array();
			//RecordPositionComment $record_position_query = $this->Member->find('list', array('fields' => 'Member.id'));
			//RecordPositionComment $record_position_list = array_keys($record_position_query); // resolve all keys to numeric array
			//RecordPositionComment $record_position = array_search($id,$record_position_list) + 1;
			$conditions = array();
			$foundset_record_count = $this->Member->find('count');
		}
					if (isset($_SESSION['toolbar_prev']))
					{
					$page['first'] = $this->Session->read('toolbar_first');
					$page['prev'] = $this->Session->read('toolbar_prev');
					$page['next'] = $this->Session->read('toolbar_next');
					$page['total_record_count'] = $this->Session->read('toolbar_total_record_count');
					$page['foundset_record_count'] = $this->Session->read('toolbar_foundset_record_count');
					$page['last'] = $this->Session->read('toolbar_last');
					$page['record_position'] = $this->Session->read('toolbar_record_position');
					$page['current_model'] = 'Member';
					$page['current_controller'] = 'members';
					}
					else 
					{	
		$first_record = $this->Member->find('first', array('conditions'=>$conditions,'recursive'=>-1, 'fields'=>array('Member.id'),'order'=>array('Member.id ASC')));
		$last_record = $this->Member->find('first', array('conditions'=>$conditions,'recursive'=>-1, 'fields'=>array('Member.id'),'order'=>array('Member.id DESC')));
		$neighbors = $this->Member->find('neighbors', array('conditions'=>$conditions,'recursive'=>-1, 'fields'=>array('Member.id'), 'field' => 'id', 'value'=> $id));
		$total_record_count = $this->Member->find('count');
		$page = array();
		$page['first'] = $first_record;
		$page['prev'] = $neighbors['prev'];
		$page['next'] = $neighbors['next'];
		$page['total_record_count'] = $total_record_count;
		$page['foundset_record_count'] = $foundset_record_count;
		$page['last'] = $last_record;
		$page['record_position'] = $record_position;
		$page['current_model'] = 'Member';
		$page['current_controller'] = 'members';
		if (empty($page['prev'])) {
			$page['prev'] = $first_record;
		}
		if (empty($page['next'])) {
			$page['next'] = $last_record;
		}
					}
					if (isset($_SESSION['toolbar_total_record_count'])) 
					{
					$this->Session->delete('toolbar_first');
					$this->Session->delete('toolbar_prev');
					$this->Session->delete('toolbar_next');
					$this->Session->delete('toolbar_total_record_count');
					$this->Session->delete('toolbar_foundset_record_count');
					$this->Session->delete('toolbar_last');
					$this->Session->delete('toolbar_record_position');
					}
		$this->set('page', $page);
		$_SESSION['MemberCurrentRecord'] = $this->data; // data for Ext JS grid
		$this->set("nav_toolbar_forms_list_value_list",$this->define_nav_toolbar_forms_list_value_list());


	} 

	function query() {
		$this->set('indextypedisplayflag','0');
		// Clear SESSION when performing a new search
		unset($_SESSION['Member']['foundset']);
		if (!empty($this->data)) {
			$conditions = array();
			foreach($this->data['Member'] as $key=>$val) {
				if (!empty($val)) {
					// Exact query
					// $conditions['Member.'.$key] = $val;
					// Fuzzy query
					$conditions['Member.'.$key.' LIKE'] = '%'.$val.'%';
				}
			}
			if (!empty($conditions)) {
				$results = $this->Member->find('all', array(
					'conditions'=>$conditions,
					'order'=>array('Member.id ASC'),
				));
				if (!empty($results)) {
					foreach($results as $result) {
						// Save found record IDs into SESSION
						$_SESSION['Member']['foundset'][] = $result['Member']['id'];
					}
				$this->set('indextypedisplayflag','2');
				} else {
					$this->Session->setFlash('0 Records Found.', 'flash_info'); 
				}
			} else {
				$this->Session->setFlash('Please enter at least one query condition.','flash_info'); 
			}
		} 
		$this->layout = "add";

		$page['current_model'] = 'Member';
		$page['current_controller'] = 'members';
		$this->set('page', $page);
		$this->set("nav_toolbar_forms_list_value_list",$this->define_nav_toolbar_forms_list_value_list());
	} 

	function querylist() {
		$page['current_model'] = 'Member';
		$page['current_controller'] = 'members';
		$this->set('page', $page);
		if (isset($_SESSION['Member']['foundset'])) {
			$this->paginate = array(
					'Member'=>array(
						'conditions'=>array(
						'Member.id'=>$_SESSION['Member']['foundset']
					),
					'order'=>array(
						'Member.id ASC'
					),
					'limit'=>10
			));
			$results = $this->paginate('Member');
			$this->set('members', $results);
		} else {
			$this->redirect(array('action'=>'query'));
		}
	}
    function clearfoundset() {
        unset($_SESSION['Member']['foundset']);
        $this->redirect(array('action'=>'index'));
    }

	function save_records_as_pdf_image28_png() {
	// Create PDF Filename: 'Member - Current Record' Using: CurrentRecord
	$this->save_records_as_pdf('Member - Current Record','CurrentRecord','download','members/view','Member','id');
	}

	function save_records_as_pdf_image28_png2() {
	// Create PDF Filename: 'Members Foundset' Using: RecordsBeingBrowsed
	$this->save_records_as_pdf('Members Foundset','RecordsBeingBrowsed','download','members/view','Member','id');
	}

	function save_records_as_pdf_image28_png3() {
	// Create PDF Filename: 'Members Blank Form' Using: BlankRecord
	$this->save_records_as_pdf('Members Blank Form','BlankRecord','download','members/add','Member','id');
	}




} // end of controller code
?>
