<?php 
class AssetsController extends AppController { 
	var $name = 'Assets'; 
	var $uses = 'TblAsset'; 
	var $components = array('Security');
	var $helpers = array('Html', 'Form', 'Paginator', 'Js'); 

	function index() { 
		if (isset($_SESSION['TblAsset']['foundset'])) {
		  $this->redirect(array('action'=>'querylist'));
        }
		$this->layout = "index";
		$this->TblAsset->recursive = -1; 
		$this->set('tbl_assets', $this->paginate()); 
		$page['current_model'] = 'TblAsset';
		$page['current_controller'] = 'assets';
		$this->set('page', $page);
	} 

	function view($id = null) { 
		if (!$id || $id == 0) {
			// if invalid id (0) or missing id, use current_record as id
			if (!isset($_SESSION['TblAsset']['current_record']))
				{
				// if invalid id and missing SESSION variable, get first record as current id
				$conditions = array();
				$first_record = $this->TblAsset->find('first', array('conditions'=>$conditions,'recursive'=>-1, 'fields'=>array('TblAsset.id'),'order'=>array('TblAsset.id ASC')));
				$id = $first_record['TblAsset']['id'];
				$_SESSION['TblAsset']['current_record']=$id;
				}	
				else {
				$id = $_SESSION['TblAsset']['current_record'];				
				}	
		}
		$this->layout = "view";
		// put the current record id into session variable
		$_SESSION['TblAsset']['current_record'] = $id;
		// record navigation variables 
		$this->data=$this->TblAsset->read(null, $id); 
		if (isset($_SESSION['TblAsset']['foundset'])) {
			$conditions = array('TblAsset.id'=>$_SESSION['TblAsset']['foundset']);
			$foundset_record_count = $_SESSION['TblAsset']['foundset'];
			// get record position within foundset
			$record_position = '';
			$record_position = array_search($id,$_SESSION['TblAsset']['foundset']) + 1;
		} else {
			// get list of keys for display of record position
			$record_position = '';
			$conditions = array();
			$record_position_query = $this->TblAsset->find('list', array('fields' => 'TblAsset.id'));
			$record_position_list = array_keys($record_position_query); // resolve all keys to numeric array
			$record_position = array_search($id,$record_position_list) + 1;
			$conditions = array();
			$foundset_record_count = $this->TblAsset->find('count');
		}
					if (isset($_SESSION['toolbar_prev']))
					{
					$page['first'] = $this->Session->read('toolbar_first');
					$page['prev'] = $this->Session->read('toolbar_prev');
					$page['next'] = $this->Session->read('toolbar_next');
					$page['total_record_count'] = $this->Session->read('toolbar_total_record_count');
					$page['foundset_record_count'] = $this->Session->read('toolbar_foundset_record_count');
					$page['last'] = $this->Session->read('toolbar_last');
					$page['record_position'] = $this->Session->read('toolbar_record_position');
					$page['current_model'] = 'TblAsset';
					$page['current_controller'] = 'assets';
					}
					else 
					{	
		$first_record = $this->TblAsset->find('first', array('conditions'=>$conditions,'recursive'=>-1, 'fields'=>array('TblAsset.id'),'order'=>array('TblAsset.id ASC')));
		$last_record = $this->TblAsset->find('first', array('conditions'=>$conditions,'recursive'=>-1, 'fields'=>array('TblAsset.id'),'order'=>array('TblAsset.id DESC')));
		$neighbors = $this->TblAsset->find('neighbors', array('conditions'=>$conditions,'recursive'=>-1, 'fields'=>array('TblAsset.id'), 'field' => 'id', 'value'=> $id));
		$total_record_count = $this->TblAsset->find('count');
		$page = array();
		$page['first'] = $first_record;
		$page['prev'] = $neighbors['prev'];
		$page['next'] = $neighbors['next'];
		$page['total_record_count'] = $total_record_count;
		$page['foundset_record_count'] = $foundset_record_count;
		$page['last'] = $last_record;
		$page['record_position'] = $record_position;
		$page['current_model'] = 'TblAsset';
		$page['current_controller'] = 'assets';
		if (empty($page['prev'])) {
			$page['prev'] = $first_record;
		}
		if (empty($page['next'])) {
			$page['next'] = $last_record;
		}
					}
					if (isset($_SESSION['toolbar_total_record_count'])) 
					{
					$this->Session->delete('toolbar_first');
					$this->Session->delete('toolbar_prev');
					$this->Session->delete('toolbar_next');
					$this->Session->delete('toolbar_total_record_count');
					$this->Session->delete('toolbar_foundset_record_count');
					$this->Session->delete('toolbar_last');
					$this->Session->delete('toolbar_record_position');
					}
		$this->set('page', $page);
		$_SESSION['TblAssetCurrentRecord'] = $this->data; // data for Ext JS grid
		$this->set("nav_toolbar_forms_list_value_list",$this->define_nav_toolbar_forms_list_value_list());

		$this->set("tbl_assets__picture_image_data",$this->data['TblAsset']['picture']);
 		$tbl_assets__picture_mime_type=$this->image_file_type_from_binary($this->data['TblAsset']['picture']); // get mime type of binary data
		$this->set("tbl_assets__picture_mime_type",$tbl_assets__picture_mime_type);
		$this->set("category_list_value_list",$this->define_category_list_value_list());
		$this->set("tbl_assets__book_value_group",$this->prepareInputGroup("checkbox","tbl_assets__book_value_group",$this->define_checkbox_1_0_value_list(),$this->data['TblAsset']['book_value'],' ','0'));
		$this->set("tbl_assets__radio_btn_test_fld2_group",$this->prepareInputGroup("radio","tbl_assets__radio_btn_test_fld2_group",$this->define_category_list_value_list(),$this->data['TblAsset']['radio_btn_test_fld2'],' ','0'));
		$this->set("tbl_assets__checkbox_test_fld2_group",$this->prepareInputGroup("checkbox","tbl_assets__checkbox_test_fld2_group",$this->define_category_list_value_list(),$this->data['TblAsset']['checkbox_test_fld2'],' ','0'));
		$this->set("tbl_assets__radio_btn_test_fld1_group",$this->prepareInputGroup("radio","tbl_assets__radio_btn_test_fld1_group",$this->define_category_list2_value_list(),$this->data['TblAsset']['radio_btn_test_fld1'],' ','1'));
		$this->set("two_field_vl___numeric_value_list",$this->define_two_field_vl___numeric_value_list());
		$this->set("two_field_vl___text_value_list",$this->define_two_field_vl___text_value_list());
		$this->set("tbl_assets__checkbox_test_fld1_group",$this->prepareInputGroup("checkbox","tbl_assets__checkbox_test_fld1_group",$this->define_category_list2_value_list(),$this->data['TblAsset']['checkbox_test_fld1'],' ','1'));
		$this->set("one_field_vl___text_value_list",$this->define_one_field_vl___text_value_list());
		$this->set("tbl_assets__checkbox_test_fld110_group",$this->prepareInputGroup("checkbox","tbl_assets__checkbox_test_fld110_group",$this->define_category_list2_value_list(),$this->data['TblAsset']['checkbox_test_fld1'],' ','2'));
		$this->set("tbl_assets__radio_btn_test_fld111_group",$this->prepareInputGroup("radio","tbl_assets__radio_btn_test_fld111_group",$this->define_category_list2_value_list(),$this->data['TblAsset']['radio_btn_test_fld1'],' ','2'));

	} 

	function query() {
		$this->set('indextypedisplayflag','0');
		// Clear SESSION when performing a new search
		unset($_SESSION['TblAsset']['foundset']);
		if (!empty($this->data)) {
		if(isset($this->params['form']['tbl_assets__book_value_group']) && count($this->params['form']['tbl_assets__book_value_group'])) {
			$this->data['TblAsset']['book_value'] = implode("\r",$this->params['form']['tbl_assets__book_value_group']);
		}
		if(isset($this->params['form']['tbl_assets__radio_btn_test_fld2_group']) && count($this->params['form']['tbl_assets__radio_btn_test_fld2_group'])) {
			$this->data['TblAsset']['radio_btn_test_fld2'] = implode("\r",$this->params['form']['tbl_assets__radio_btn_test_fld2_group']);
		}
		if(isset($this->params['form']['tbl_assets__checkbox_test_fld2_group']) && count($this->params['form']['tbl_assets__checkbox_test_fld2_group'])) {
			$this->data['TblAsset']['checkbox_test_fld2'] = implode("\r",$this->params['form']['tbl_assets__checkbox_test_fld2_group']);
		}
		if(isset($this->params['form']['tbl_assets__radio_btn_test_fld1_group']) && count($this->params['form']['tbl_assets__radio_btn_test_fld1_group'])) {
			$this->data['TblAsset']['radio_btn_test_fld1'] = implode("\r",$this->params['form']['tbl_assets__radio_btn_test_fld1_group']);
		}
		if(isset($this->params['form']['tbl_assets__checkbox_test_fld1_group']) && count($this->params['form']['tbl_assets__checkbox_test_fld1_group'])) {
			$this->data['TblAsset']['checkbox_test_fld1'] = implode("\r",$this->params['form']['tbl_assets__checkbox_test_fld1_group']);
		}
		if(isset($this->params['form']['tbl_assets__checkbox_test_fld110_group']) && count($this->params['form']['tbl_assets__checkbox_test_fld110_group'])) {
			$this->data['TblAsset']['checkbox_test_fld1'] = implode("\r",$this->params['form']['tbl_assets__checkbox_test_fld110_group']);
		}
		if(isset($this->params['form']['tbl_assets__radio_btn_test_fld111_group']) && count($this->params['form']['tbl_assets__radio_btn_test_fld111_group'])) {
			$this->data['TblAsset']['radio_btn_test_fld1'] = implode("\r",$this->params['form']['tbl_assets__radio_btn_test_fld111_group']);
		}
			$conditions = array();
			foreach($this->data['TblAsset'] as $key=>$val) {
				if (!empty($val)) {
					// Exact query
					// $conditions['TblAsset.'.$key] = $val;
					// Fuzzy query
					$conditions['TblAsset.'.$key.' LIKE'] = '%'.$val.'%';
				}
			}
			if (!empty($conditions)) {
				$results = $this->TblAsset->find('all', array(
					'conditions'=>$conditions,
					'order'=>array('TblAsset.id ASC'),
				));
				if (!empty($results)) {
					foreach($results as $result) {
						// Save found record IDs into SESSION
						$_SESSION['TblAsset']['foundset'][] = $result['TblAsset']['id'];
					}
				$this->set('indextypedisplayflag','2');
				} else {
					$this->Session->setFlash('0 Records Found.', 'flash_info'); 
				}
			} else {
				$this->Session->setFlash('Please enter at least one query condition.','flash_info'); 
			}
		} 
		$this->layout = "add";

		$this->set("category_list_value_list",$this->define_category_list_value_list());
		$this->set("tbl_assets__book_value_group",$this->prepareInputGroup("checkbox","tbl_assets__book_value_group",$this->define_checkbox_1_0_value_list(),null,' ','0'));
		$this->set("tbl_assets__radio_btn_test_fld2_group",$this->prepareInputGroup("radio","tbl_assets__radio_btn_test_fld2_group",$this->define_category_list_value_list(),null,' ','0'));
		$this->set("tbl_assets__checkbox_test_fld2_group",$this->prepareInputGroup("checkbox","tbl_assets__checkbox_test_fld2_group",$this->define_category_list_value_list(),null,' ','0'));
		$this->set("tbl_assets__radio_btn_test_fld1_group",$this->prepareInputGroup("radio","tbl_assets__radio_btn_test_fld1_group",$this->define_category_list2_value_list(),null,' ','1'));
		$this->set("two_field_vl___numeric_value_list",$this->define_two_field_vl___numeric_value_list());
		$this->set("two_field_vl___text_value_list",$this->define_two_field_vl___text_value_list());
		$this->set("tbl_assets__checkbox_test_fld1_group",$this->prepareInputGroup("checkbox","tbl_assets__checkbox_test_fld1_group",$this->define_category_list2_value_list(),null,' ','1'));
		$this->set("one_field_vl___text_value_list",$this->define_one_field_vl___text_value_list());
		$this->set("tbl_assets__checkbox_test_fld110_group",$this->prepareInputGroup("checkbox","tbl_assets__checkbox_test_fld110_group",$this->define_category_list2_value_list(),null,' ','2'));
		$this->set("tbl_assets__radio_btn_test_fld111_group",$this->prepareInputGroup("radio","tbl_assets__radio_btn_test_fld111_group",$this->define_category_list2_value_list(),null,' ','2'));
		$page['current_model'] = 'TblAsset';
		$page['current_controller'] = 'assets';
		$this->set('page', $page);
		$this->set("nav_toolbar_forms_list_value_list",$this->define_nav_toolbar_forms_list_value_list());
	} 

	function querylist() {
		$page['current_model'] = 'TblAsset';
		$page['current_controller'] = 'assets';
		$this->set('page', $page);
		if (isset($_SESSION['TblAsset']['foundset'])) {
			$this->paginate = array(
					'TblAsset'=>array(
						'conditions'=>array(
						'TblAsset.id'=>$_SESSION['TblAsset']['foundset']
					),
					'order'=>array(
						'TblAsset.id ASC'
					),
					'limit'=>10
			));
			$results = $this->paginate('TblAsset');
			$this->set('tbl_assets', $results);
		} else {
			$this->redirect(array('action'=>'query'));
		}
	}
    function clearfoundset() {
        unset($_SESSION['TblAsset']['foundset']);
        $this->redirect(array('action'=>'index'));
    }

	function save_records_as_pdf_line27() {
	// Create PDF Filename: 'Assets - Blank' Using: BlankRecord
	$this->save_records_as_pdf('Assets - Blank','BlankRecord','download','assets/add','TblAsset','id');
	}





	function condition_list_vltojson() {									
		$this->layout=null;
		$data=array();
		$condition_list_value_list=$this->define_condition_list_value_list();
		$total = count($condition_list_value_list);  
        foreach($condition_list_value_list as $key=>$value)
		{   
			array_push($data,array(  
			'field_data'=>$key,
			'field_label'=>$value  
			));
		}		
		echo json_encode($data);
	 }

	function portal1_data() {
		 // convert model data into JSON formatted data for the ExtJS Grid
		 $data=array(); 
		 $i=0;
		 $totaldata=$_SESSION['TblAssetCurrentRecord'];

//-- Note: This code doesn't handle portal fields from multiple TOs
		 $tblrecordarray=$totaldata[''];
		 for($j=0;$j<count($tblrecordarray);$j++)
		 	 {
		 	 $singlearray=$tblrecordarray[$j];
		 	 array_push($data,array( 
		 	 ));
		 	 }
		 $this->layout=null;		 
		 echo json_encode($data);
	}

	function portal624_data() {
		 // convert model data into JSON formatted data for the ExtJS Grid
		 $data=array(); 
		 $i=0;
		 $totaldata=$_SESSION['TblAssetCurrentRecord'];

//-- Note: This code doesn't handle portal fields from multiple TOs
		 $tblrecordarray=$totaldata['TblMaintenanceRecord'];
		 for($j=0;$j<count($tblrecordarray);$j++)
		 	 {
		 	 $singlearray=$tblrecordarray[$j];
		 	 array_push($data,array(  
		 	 'id'=>$singlearray['id'],
		 	 'asset_id'=>$singlearray['asset_id'],
		 	 'date_'=>date("m/d/Y", strtotime($singlearray['date_'])),
		 	 'notes'=>$singlearray['notes']
		 	 ));
		 	 }
		 $this->layout=null;		 
		 echo json_encode($data);
	}

	function portal104_data() {
		 // convert model data into JSON formatted data for the ExtJS Grid
		 $data=array(); 
		 $i=0;
		 $totaldata=$_SESSION['TblAssetCurrentRecord'];

//-- Note: This code doesn't handle portal fields from multiple TOs
		 $tblrecordarray=$totaldata['TblMaintenanceRecord'];
		 for($j=0;$j<count($tblrecordarray);$j++)
		 	 {
		 	 $singlearray=$tblrecordarray[$j];
		 	 array_push($data,array(  
		 	 'asset_id'=>$singlearray['asset_id'],
		 	 'id'=>$singlearray['id'],
		 	 'date_'=>date("m/d/Y", strtotime($singlearray['date_'])),
		 	 'notes'=>$singlearray['notes'],
		 	 'maint_picture'=>$singlearray['maint_picture'],
		 	 'maint_condition1'=>$singlearray['maint_condition1'],
		 	 'maint_condition2'=>$singlearray['maint_condition2'],
		 	 'maint_condition3'=>$singlearray['maint_condition3'],
		 	 'maint_condition4'=>$singlearray['maint_condition4']
		 	 ));
		 	 }
		 $this->layout=null;		 
		 echo json_encode($data);
	}
} // end of controller code
?>
