<?php
/**
 * Application level Controller
 *
 * This file is application-wide controller file. You can put all
 * application-wide controller-related methods here.
 *
 * PHP versions 4 and 5
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2010, Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright 2005-2010, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       cake
 * @subpackage    cake.cake.libs.controller
 * @since         CakePHP(tm) v 0.2.9
 * @license       MIT License (http://www.opensource.org/licenses/mit-license.php)
 */

/**
 * This is a placeholder class.
 * Create the same file in app/app_controller.php
 *
 * Add your application-wide methods in the class below, your controllers
 * will inherit them.
 *
 * @package       cake
 * @subpackage    cake.cake.libs.controller
 * @link http://book.cakephp.org/view/957/The-App-Controller
 */
	App::import('Model', 'TblAsset');
	App::import('Model', 'TblMaintenanceRecord');
	App::import('Model', 'TblValueListDataItem');
	App::import('Model', 'Member');
	App::import('Model', 'Companie');
	App::import('Model', 'User');
	App::import('Model', 'Token');

class AppController extends Controller {
	var $helpers = array('Html', 'Form', 'Paginator', 'Js', 'Session'); 
// 	var $components = array('Session','Auth' => array(
// 									'authorize' => 'controller',
// 									'userScope' => array('User.inactive' => false),
// 									'loginError' => 'Login Error: Invalid username or password',
// 									'authError' => 'Your user account role does not have access to this feature'));
//     
//     public function isAuthorized() {
//     $current_username = $this->Auth->user('username');
//     $this->set('current_username', $current_username);
// 	switch (true) {
// 		case ($this->Auth->user('role') == '[Read-Only Access]') && ( $this->action=='add' || $this->action=='edit' || $this->action=='delete' || $this->action=='addgridrow' || $this->action=='editgridrow' || $this->action=='deletegridrow'):
// 			$this->Session->setFlash('Your user account role (' . $this->Auth->user('role') . ') does not have access to this feature (' . $this->action .').','flash_error');
// 			return false;
// 			break;
// 		case ($this->Auth->user('role') == '[Edit Only]') && ( $this->action=='add' || $this->action=='delete' || $this->action=='addgridrow' || $this->action=='deletegridrow'):
// 			$this->Session->setFlash('Your user account role (' . $this->Auth->user('role') . ') does not have access to this feature (' . $this->action .').','flash_error');
// 			return false;
// 			break;
// 		default:
// 			return true;
// 			break;
// 		}
// 	}
	/* ---------------------------------------------
	* ----------         Value Lists      ----------
	/* ---------------------------------------------*/
	function define_nav_toolbar_forms_list_value_list() {
		// Value List: nav_toolbar_forms_list_value_list - used by toolbar forms menu
		$nav_toolbar_forms_list_value_list = array("assets/TblAsset"=>"Assets","bar_chart_gallery/Member"=>"Bar Chart Gallery","maint_record/TblMaintenanceRecord"=>"Maint_Record","members/Member"=>"Members","pie_chart_gallery/Member"=>"Pie Chart Gallery");
		return $nav_toolbar_forms_list_value_list;
		}
	function define_category_list_value_list() {
		// Value List: category_list
		$category_list_value_list = array("Office Furniture"=>"Office Furniture","Computers"=>"Computers","Telephones"=>"Telephones","-"=>"-");
		return $category_list_value_list;
		}

	function define_category_list2_value_list() {
		// Value List: category_list2
		$category_list2_value_list = array("Office Furniture"=>"Office Furniture","Computers"=>"Computers","Telephones"=>"Telephones","Table"=>"Table","Chair"=>"Chair","Router"=>"Router");
		return $category_list2_value_list;
		}

	function define_checkbox_1_0_value_list() {
		// Value List: checkbox_1_0
		$checkbox_1_0_value_list = array("1"=>"");
		return $checkbox_1_0_value_list;
		}

	function define_condition_list_value_list() {
		// Value List: condition_list
		$condition_list_value_list = array("New"=>"New","Excellent"=>"Excellent","Good"=>"Good","Poor"=>"Poor","Scrap"=>"Scrap");
		return $condition_list_value_list;
		}

	function define_forms_list_value_list() {
		// Value List: forms_list
		$forms_list_value_list = array("Assets"=>"Assets","Maintenance Record"=>"Maintenance Record");
		return $forms_list_value_list;
		}

	function define_item_list_value_list() {
		// Value List: item_list
		$TblAsset = new TblAsset;
		$item_list_value_list=$TblAsset->find('list',array("fields"=>array("TblAsset.item","TblAsset.item"),"conditions"=>array("TblAsset.item <>"=>null),"group"=>array("TblAsset.item"),"order"=>array("TblAsset.item ASC")));
		return $item_list_value_list;
		}

	function define_maint_status_value_list__text__value_list() {
		// Value List: maint_status_value_list__text_
		$TblMaintenanceRecord = new TblMaintenanceRecord;
		$maint_status_value_list__text__value_list=$TblMaintenanceRecord->find('list',array("fields"=>array("TblMaintenanceRecord.maint_condition2","TblMaintenanceRecord.maint_condition2"),"conditions"=>array("TblMaintenanceRecord.maint_condition2 <>"=>null),"group"=>array("TblMaintenanceRecord.maint_condition2"),"order"=>array("TblMaintenanceRecord.maint_condition2 ASC")));
		return $maint_status_value_list__text__value_list;
		}

	function define_maint_status_value_list__text_2_value_list() {
		// Value List: maint_status_value_list__text_2
		$TblMaintenanceRecord = new TblMaintenanceRecord;
		$maint_status_value_list__text_2_value_list=$TblMaintenanceRecord->find('list',array("fields"=>array("TblMaintenanceRecord.maint_condition1","TblMaintenanceRecord.maint_condition1"),"conditions"=>array("TblMaintenanceRecord.maint_condition1 <>"=>null),"group"=>array("TblMaintenanceRecord.maint_condition1"),"order"=>array("TblMaintenanceRecord.maint_condition1 ASC")));
		return $maint_status_value_list__text_2_value_list;
		}

	function define_maint_status_value_list__numeric__value_list() {
		// Value List: maint_status_value_list__numeric_
		$TblMaintenanceRecord = new TblMaintenanceRecord;
		$query_result=$TblMaintenanceRecord->find('list',array("fields"=>array("TblMaintenanceRecord.id","TblMaintenanceRecord.maint_condition1"),"conditions"=>array("TblMaintenanceRecord.id <>"=>null),"group"=>array("TblMaintenanceRecord.id","TblMaintenanceRecord.maint_condition1"),"order"=>array("TblMaintenanceRecord.id,TblMaintenanceRecord.maint_condition1 ASC")));
		$maint_status_value_list__numeric__value_list = array();
		if (!empty($query_result)) {
			foreach($query_result as $key=>$value) {
			$maint_status_value_list__numeric__value_list[$key] = $key.' '.$value;
			}
		}
		return $maint_status_value_list__numeric__value_list;
		}

	function define_maint_status_value_list__numeric_2_value_list() {
		// Value List: maint_status_value_list__numeric_2
		$TblMaintenanceRecord = new TblMaintenanceRecord;
		$maint_status_value_list__numeric_2_value_list=$TblMaintenanceRecord->find('list',array("fields"=>array("TblMaintenanceRecord.id","TblMaintenanceRecord.id"),"conditions"=>array("TblMaintenanceRecord.id <>"=>null),"group"=>array("TblMaintenanceRecord.id"),"order"=>array("TblMaintenanceRecord.id ASC")));
		return $maint_status_value_list__numeric_2_value_list;
		}

	function define_one_field_vl___numeric_value_list() {
		// Value List: one_field_vl___numeric
		$TblValueListDataItem = new TblValueListDataItem;
		$one_field_vl___numeric_value_list=$TblValueListDataItem->find('list',array("fields"=>array("TblValueListDataItem.id","TblValueListDataItem.id"),"conditions"=>array("TblValueListDataItem.id <>"=>null),"group"=>array("TblValueListDataItem.id"),"order"=>array("TblValueListDataItem.id ASC")));
		return $one_field_vl___numeric_value_list;
		}

	function define_one_field_vl___text_value_list() {
		// Value List: one_field_vl___text
		$TblValueListDataItem = new TblValueListDataItem;
		$one_field_vl___text_value_list=$TblValueListDataItem->find('list',array("fields"=>array("TblValueListDataItem.text_label","TblValueListDataItem.text_label"),"conditions"=>array("TblValueListDataItem.text_label <>"=>null),"group"=>array("TblValueListDataItem.text_label"),"order"=>array("TblValueListDataItem.text_label ASC")));
		return $one_field_vl___text_value_list;
		}

	function define_query_operators_value_list() {
		// Value List: query_operators
		$query_operators_value_list = array("< less than"=>"< less than","≤ less than or equal"=>"≤ less than or equal","> greater than"=>"> greater than","≥ greater than or equal"=>"≥ greater than or equal","= exact match"=>"= exact match","% begins or ends with"=>"% begins or ends with");
		return $query_operators_value_list;
		}

	function define_two_field_vl___text_value_list() {
		// Value List: two_field_vl___text
		$TblValueListDataItem = new TblValueListDataItem;
		$query_result=$TblValueListDataItem->find('list',array("fields"=>array("TblValueListDataItem.id","TblValueListDataItem.text_label"),"conditions"=>array("TblValueListDataItem.id <>"=>null),"group"=>array("TblValueListDataItem.text_label"),"order"=>array("TblValueListDataItem.text_label ASC")));
		$two_field_vl___text_value_list = array();
		if (!empty($query_result)) {
			foreach($query_result as $key=>$value) {
			$two_field_vl___text_value_list[$key] = $value;
			}
		}
		return $two_field_vl___text_value_list;
		}

	function define_two_field_vl___numeric_value_list() {
		// Value List: two_field_vl___numeric
		$TblValueListDataItem = new TblValueListDataItem;
		$query_result=$TblValueListDataItem->find('list',array("fields"=>array("TblValueListDataItem.id","TblValueListDataItem.text_label"),"conditions"=>array("TblValueListDataItem.id <>"=>null),"group"=>array("TblValueListDataItem.id","TblValueListDataItem.text_label"),"order"=>array("TblValueListDataItem.id,TblValueListDataItem.text_label ASC")));
		$two_field_vl___numeric_value_list = array();
		if (!empty($query_result)) {
			foreach($query_result as $key=>$value) {
			$two_field_vl___numeric_value_list[$key] = $key.' '.$value;
			}
		}
		return $two_field_vl___numeric_value_list;
		}

	/*
	* This function takes image binary data and returns it's mime type
	*/
	function image_file_type_from_binary($binary) {
		if (
			!preg_match(
				'/\A(?:(\xff\xd8\xff)|(GIF8[79]a)|(\x89PNG\x0d\x0a)|(BM)|(\x49\x49(\x2a\x00|\x00\x4a))|(FORM.{4}ILBM))/',
				$binary, $hits
			)
		) {
			return 'application/octet-stream';
		}
		static $type = array (
			1 => 'image/jpeg',
			2 => 'image/gif',
			3 => 'image/png',
			4 => 'image/x-windows-bmp',
			5 => 'image/tiff',
			6 => 'image/x-ilbm',
		);
		return $type[count($hits) - 1];
	}
	 function save_records_as_pdf($filename,$records_to_save,$download_type,$form_name,$model_name,$pkcolumn)    {	 
	/*
	* ----- create a PDF of the specified form ---
	* @filename = output PDF filename, without .pdf extension
	* @records_to_save = records to use for creating pdf (CurrentRecord,RecordsBeingBrowsed,BlankRecord)
	* @download_type = prompt for file download or display inline within browser (download,file,browser)
	* @form_name = name of view file to render into pdf (Contact/view, Contact/pdfview)
	* @model_name = name of the model
	* @pkcolumn = name of primary key column
	*/
		$GLOBALS['g_config'] = array(
                             'landscape'     => false
                             );	

	switch ($records_to_save) {
		case "CurrentRecord":
		// current record
		// Include Component
		App::import('Component', 'Pdf');
		// Make instance
		$Pdf = new PdfComponent();
		// Output filenamename
		$Pdf->filename = $filename; // Without .pdf
		// You can use download or browser here
		$Pdf->output = $download_type;
		$Pdf->media = 'Letter';
		$Pdf->init();
		// Render the view
		$Pdf->process(Router::url('/', true) . $form_name."/".$_SESSION[$model_name]['current_record']);
		$this->layout = null;
		break;
		
		case "RecordsBeingBrowsed":
		// save foundset of records
		$url=array();
		// Include Component
		App::import('Component', 'Pdfbatch');
		// Make instance
		$Pdf = new PdfComponents();
		// Output filenamename
		$Pdf->filename = $filename; // Without .pdf
		// You can use download or browser here
		$Pdf->output = $download_type;
		$Pdf->init();
			
		if(isset($_SESSION[$model_name]['foundset']))
			{
				// foundset of records
				$recordcount=count($_SESSION[$model_name]['foundset']);
				for($i=0;$i<$recordcount;$i++)
					{
						$id=$_SESSION[$model_name]['foundset'][$i];
						$url[$i]=Router::url('/', true).$form_name.'/'.$id;
					}
						// Render the view for the current record
						$Pdf->process($url);
						$this->layout = null;
				}
			 else
			{
				// all records
				 $this->$model_name->recursive=-1; // skip related records
				 $recordsfound=$this->$model_name->find('all');
				 $recordcount=count($recordsfound);
					for($i=0;$i<$recordcount;$i++)
					{
						$id=$recordsfound[$i][$model_name][$pkcolumn];
						$url[$i]=Router::url('/', true).$form_name.'/'.$id;
					}
						 // Render the view for the current record
						$Pdf->process($url);
						$this->layout = null;
			}
		break;
		
		case "BlankRecord":
		// save a blank record - no data
		// Include Component
		App::import('Component', 'Pdf');
		// Make instance
		$Pdf = new PdfComponent();
		// Output filenamename
		$Pdf->filename = $filename; // Without .pdf
		// You can use download or browser here
		$Pdf->output = $download_type;
		$Pdf->init();
		// Render the view
		$Pdf->process(Router::url('/', true) . $form_name);
		$this->layout = null;
		break;

		}
	 }

	/*
	* @type=String (checkbox,radio)
	* @group_name= String (this name will be indexed and sent to the server as an array of inputs. example checkbox_group)
	* @arr=the associative array of values to generate the group
	* @select1=the field of the model associated with the field
	* @separator=the item separator used to build the group
	* @columns=the number of columns to build (0,1,2 etc)
	* @example: type=checkbox,group_name=my_group,arr=array("1"=>"hi","2"=>"hello")
	*/
   	function prepareInputGroup($type,$group_name,$arr,$select1=null,$separator='',$columns=0){
		$str="";
		$select = ($select1) ? explode("\r",$select1) : array();
		$cnt=0;
		$max=0;
		$maxColumn=array();
		$j=0;
		$k=0;
		$arrCount=count($arr)-1;
		$arrLoopCounter=0;
		if($columns!=0)
		// column processing for one or more columns is needed
		{
			// calculate padding spaces needed for each row
			foreach($arr as $key=>$value)
			{
				$j++;
				$len=strlen($value);
			  
				$pos = $j % $columns;
				if(isset($maxColumn[$k]))
				{
					if($maxColumn[$k]<$len)
						$maxColumn[$k]=$len;
				}
				else
				{
					$maxColumn[$k]=$len;
				}
				
				if($j % $columns==0){
					$k=0;
				}
				else
					$k++;
			}

			// add padding spaces to $value for output
			$k=0;
			foreach($arr as $key=>$value)
			{
				$max=$maxColumn[$k];
				$k++;
				$len=strlen($value);
				if($len<$max){
					$appendspace=$max-$len;
					for ($i = 0; $i < $appendspace; $i++) {
						$value=$value."&nbsp;";
					}
				}
				$str .= ($str) ? $separator : '';
				switch($type) {
					case "checkbox":
						$checked = (in_array($key,$select)) ? 'checked="checked"':'';
						$str .= "<input type='".$type."' ".$checked." name='".$group_name."[]' value='".$key."' /> ".$value.' ';
					
						break;
					case "radio":
						$checked = (in_array($key,$select)) ? 'checked="checked"':'';
						$str .= "<input type='".$type."' ".$checked." name='".$group_name."[]' value='".$key."' /> ".$value.' ';
						break;
					default:
						$str.= "<input type='".$type."' name='".$group_name."[]' value='".$key."' /> ".$value;
				}
				$cnt++;
				if($cnt==$arrCount) {
					// last item found - add fixup padding
					// $str.="&nbsp;&nbsp;&nbsp;";
					}
				$modvalue= $cnt % $columns;
				if($modvalue==0)
				{
					$str.="<br/>";
					$k=0;
				}
			} // end of loop thru all items
			$value=$value."=";
		}
		else
		// no column processing needed
		{
			foreach($arr as $key=>$value)
			{
				$str .= ($str) ? $separator : '';
				switch($type) {
					case "checkbox":
						$checked = (in_array($key,$select)) ? 'checked="checked"':'';
						$str .= "<input type='".$type."' ".$checked." name='".$group_name."[]' value='".$key."' /> ".$value.' ';
						break;
					case "radio":
						$checked = (in_array($key,$select)) ? 'checked="checked"':'';
						$str .= "<input type='".$type."' ".$checked." name='".$group_name."[]' value='".$key."' /> ".$value.' ';
						break;
					default:
						$str.= "<input type='".$type."' name='".$group_name."[]' value='".$key."' /> ".$value;
				}
				$cnt++;
			}
		}
		return $str;
	} // end of prepareInputGroup

	function checkboxDataToArray($field_data = null) {
		$data_to_save = array();
		if (!empty($field_data)){
			foreach($field_data['checkbox'] as $k=>$v) {
				if ($v) {
					$data_to_save[] = $k;
				}
			}
		}
	return $data_to_save;
	} // end of checkboxDataToArray
} // end of app_controller
